package edu.uky.ai.lp.gui;

import java.awt.BorderLayout;

import javax.swing.JFrame;

import edu.uky.ai.lp.Game;
import edu.uky.ai.lp.Settings;

public class WumpusFrame extends JFrame {

	private static final long serialVersionUID = Settings.VERSION_UID;
	public final GamePanel game;
	public final Console console;

	public WumpusFrame(Game game) {
		super(Settings.TITLE);
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		getContentPane().setLayout(new BorderLayout());
		WumpusPanel panel = new WumpusPanel(game);
		this.game = panel.game;
		this.console = panel.console;
		getContentPane().add(panel, BorderLayout.CENTER);
		pack();
		panel.requestFocusInWindow();
		setLocationRelativeTo(null);
		setVisible(true);
	}
}
